﻿using log4net;
using System;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.IWS.MappingService.Interface;
using VA.PPMS.IWS.MappingService.Mappers;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService
{
    public class MappingService : IMappingService
    {
        private readonly ILog _logger;
        private readonly MapProviderToCrm _providerMapper;

        public PpmsReference References { get; set; }

        public MappingService(ILog logger, MapProviderToCrm providerMapper)
        {
            _logger = logger;
            _providerMapper = providerMapper;
        }

        public async Task<MapperResult> MapAsync(Providers providers)
        {
            return await MapProviderToAccount(providers);
        }
        
        private async Task<MapperResult> MapProviderToAccount(Providers providers)
        {
            if (providers.Provider.Count < 1) return new MapperResult();

            var results = new MapperResult();

            // Set PPMS References
            if (References != null)
                _providerMapper.SetPpmsReferences(References);
            else
                await _providerMapper.ResetPpmsReferences();

            foreach (var provider in providers.Provider)
            {
                try
                {
                    results.Add(await _providerMapper.Map(provider, providers.NetworkId, providers.IsVaNetwork, providers.OwnerId));
                }
                catch (Exception ex)
                {
                    string msg = ex.Message;
                    if (ex.InnerException != null) msg = $"{msg}; {ex.InnerException.Message}";
                    results.Add(new MapperResultDetail { SchemaId = provider.ProviderId, ValidationMessage = msg });
                }
            }

            return results;
        }
    }
}